/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.util.Tuple;
import java.util.List;
import java.util.Set;

public class MaxTimeScorer
extends Processor {
    private String scoreProperty = "max_time_score";
    private long defaultScore = Long.MIN_VALUE;

    public void setScoreProperty(String scoreProperty) {
        this.scoreProperty = scoreProperty;
    }

    public String getScoreProperty() {
        return this.scoreProperty;
    }

    public void setDefaultScore(long defaultScore) {
        this.defaultScore = defaultScore;
    }

    public long getDefaultScore() {
        return this.defaultScore;
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        for (Operation op : ops) {
            long maxTime = op.getAction().getMaxTimeToPrepare();
            long prevEnd = 0L;
            if (maxTime != -1L) {
                prevEnd = Util.getPreviousOperationEnd(op);
            }
            for (Operation.OperationPlanning planning : op.getPlannings()) {
                ActionActivity firstAa;
                long score = this.defaultScore;
                if (maxTime != -1L && prevEnd != Long.MIN_VALUE && (firstAa = Util.getFirstPlannedAa(planning)) != null) {
                    score = firstAa.getStart() - (prevEnd + maxTime);
                }
                planning.setProperty(this.scoreProperty, score);
            }
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }
}

